/*
 * Decompiled with CFR 0.152.
 */
package com.acs.smartcard;

public class ReadKeyOption {
    private byte[] a = new byte[6];

    public ReadKeyOption() {
    }

    public ReadKeyOption(int timeOut, int pinMaxExtraDigit, int keyReturnCondition, int echoLcdStartPosition, int echoLcdMode) {
        this.setTimeOut(timeOut);
        this.setPinMaxExtraDigit(pinMaxExtraDigit);
        this.setKeyReturnCondition(keyReturnCondition);
        this.setEchoLcdStartPosition(echoLcdStartPosition);
        this.setEchoLcdMode(echoLcdMode);
    }

    public int getTimeOut() {
        return this.a[0] & 0xFF;
    }

    public void setTimeOut(int timeOut) {
        this.a[0] = (byte)timeOut;
    }

    public int getPinMaxExtraDigit() {
        return this.a[1] & 0xFF | (this.a[2] & 0xFF) << 8;
    }

    public void setPinMaxExtraDigit(int pinMaxExtraDigit) {
        this.a[1] = (byte)pinMaxExtraDigit;
        this.a[2] = (byte)(pinMaxExtraDigit >> 8);
    }

    public int getKeyReturnCondition() {
        return this.a[3] & 0xFF;
    }

    public void setKeyReturnCondition(int keyReturnCondition) {
        this.a[3] = (byte)keyReturnCondition;
    }

    public int getEchoLcdStartPosition() {
        return this.a[4] & 0xFF;
    }

    public void setEchoLcdStartPosition(int echoLcdStartPosition) {
        this.a[4] = (byte)echoLcdStartPosition;
    }

    public int getEchoLcdMode() {
        return this.a[5] & 0xFF;
    }

    public void setEchoLcdMode(int echoLcdMode) {
        this.a[5] = (byte)echoLcdMode;
    }

    public byte[] toByteArray() {
        return this.a;
    }
}

